"""This file contains the map schema for the application."""

from typing import List

from pydantic import (
    BaseModel,
    Field,
)


class AccidentResponse(BaseModel):
    """Response model for accidents.

    Attributes:
        id: The unique identifier for the province
        year: year of accident
        leading_to_death: accidents which leads to death
        lead_to_injury: accidents which leads to injury
        lead_to_damage: accidents which leads to damage
    """

    id: str = Field(..., description="The unique identifier for the news")
    year: str = Field(..., description="Year of the accidents", max_length=4)
    all_accident: str = Field(..., description="Number of all_accident")
    leading_to_death: str = Field(..., description="Number of accidents which leads to death")
    lead_to_injury: str = Field(..., description="Number of accidents which leads to injury")
    lead_to_damage: str = Field(..., description="Number of accidents which leads to damage")
