"""This file contains the map schema for the application."""

import re
from typing import List

from pydantic import (
    BaseModel,
    Field,
)


class MapResponse(BaseModel):
    """Response model for map.

    Attributes:
        id: The unique identifier for the province
        province: Name of the province
        active_user: Number of active user in that province
        related_news: Number of related news gathered by crawlers
        tags: Related tags.
        agent_analysis: Agent analysis about province

    """

    id: str = Field(..., description="The unique identifier for the news")
    province: str = Field(..., description="Name of the province", max_length=128)
    active_user: str = Field(..., description="Number of active user in this province", max_length=16)
    related_news: str = Field(..., description="Number of related news in this province", max_length=16)
    tags: List = Field(..., description="List of related tags in the province")
    agent_analysis: str = Field(..., description="Agent analysis about province")
